/*
** MPEG Audio stream infomation treating interfaces
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 3/5 coding start
**
*/

#ifndef MP3_INFO_H
#define MP3_INFO_H

#include <stdio.h>
#include <stdlib.h>

#ifdef  __cplusplus
extern "C" {
#endif

#define MPEG_VERSION_UNKNOWN  -1
#define MPEG_VERSION_1         0
#define MPEG_VERSION_2         1
#define MPEG_VERSION_2_5       2

#define MPEG_AUDIO_LAYER_UNKNOWN  -1
#define MPEG_AUDIO_LAYER_1         0
#define MPEG_AUDIO_LAYER_2         1
#define MPEG_AUDIO_LAYER_3         2

#define MP3_PADDING_ISO  0
#define MP3_PADDING_ON   1
#define MP3_PADDING_OFF  2

typedef struct {
	char *path;
	FILE *stream;
	size_t length;

	/* basic MPEG Audio header info      */
	int version; /* MPEG_VERSION_X       */
	int layer;   /* MPEG_AUDIO_LAYER_X   */
	int bitrate; /* kbits/sec            */
	int sample;  /* Hz                   */
	int stereo;  /* 0 - mono, 1 - stereo */
    int padding; /* MP3_PADDING_X        */
}MP3_INFO;

#ifndef MP3_INFO_C
extern int get_mp3_info(FILE *in, MP3_INFO *out);
extern int open_mp3_file(char *in, MP3_INFO *out);
extern int close_mp3_file(MP3_INFO *mp3i);
#endif

#ifdef  __cplusplus
}
#endif

#endif

	